function [cllr] = cllr_calc(LR,lab_test,value)

% calculates cllr value 
% Based on Part I : Section 3.3.2 Eq. 6
%% input
% LR : likelihood ratio for the test scores
% lab_test : same source(1), different source(0)
% value : takes value 1 for same source numerator, takes value 0 for
% different source numerator
%% output
% cllr : The cllr value based on the formula in Section 3.3.2 Eq. 6

same_idx=find(single(lab_test)==single(value)); %% training male indexes
diff_idx=setdiff(1:length(lab_test),same_idx);%% training female indexes

cllr=0;
% Calculation for numerator and denominator
if value==1
    [xr yr]=size(LR(same_idx));
    L= log2(1+(1./LR(same_idx)));
    Num=sum(L)/length(same_idx); % for numerator
    
    L1= log2(1+LR(diff_idx));
    Denom=sum(L1)/length(diff_idx); % for denominator
    cllr=(Num+Denom)/2;
else
    L= log2(1+(1./LR(diff_idx)));
    Num=sum(L)/length(diff_idx); % for numerator
    
    L1= log2(1+LR(same_idx));
    Denom=sum(L1)/length(same_idx); % for denominator
    cllr=(Num+Denom)/2;
end

